# Wadsworth AI PCs — QC Checklist (v1)

Print this and initial each line during production.

## Device info
- Model/Family: ______________________
- CPU: _______________________________
- RAM: _______________________________
- Storage (SSD): ______________________
- Screen res: _________________________
- Charger included:  ☐ Yes  ☐ No
- Grade: ☐ A  ☐ B  ☐ C
- Serial (optional): ___________________
- Tech initials/date: _________________

---

## A) Intake hardware test (before imaging)
- ☐ Boots to BIOS/UEFI reliably
- ☐ No BIOS password lock (or cleared)
- ☐ Keyboard: all keys respond (quick pass)
- ☐ Trackpad + click: works
- ☐ Screen: no flicker/lines/pressure marks
- ☐ Hinges: firm, no cracks/separation
- ☐ Battery: not swollen; charges
- ☐ Wi‑Fi present (device visible)
- ☐ Speakers produce sound
- ☐ Webcam works (if present)
- ☐ USB ports: at least 1 tested
- ☐ Fan/thermals: no random shutdown during 10-min idle

Notes: _______________________________________________________________

---

## B) Imaging + first boot
- ☐ Correct golden image applied for model family
- ☐ First-boot automation completed without errors
- ☐ Hostname set (unique)
- ☐ OS fully updated after first boot
- ☐ Timeshift "Factory Fresh" snapshot created (or scheduled)

Notes: _______________________________________________________________

---

## C) Post-image functional test
- ☐ Boots cleanly 3 times in a row
- ☐ Login works and desktop loads quickly
- ☐ Wi‑Fi connects and stays connected for 5 minutes
- ☐ Bluetooth toggle present (if applicable)
- ☐ Sleep → wake works
- ☐ Audio test: plays a test video
- ☐ Webcam test (if present)
- ☐ Browser test (Firefox): loads 3 sites
- ☐ Browser fallback (Chromium) launches
- ☐ LibreOffice opens a document
- ☐ VLC opens sample video/audio
- ☐ Software Manager opens
- ☐ Update Manager opens

---

## D) Wadsworth AI features
- ☐ "Wadsworth Welcome Center" opens
- ☐ AI Hub opens; links work (ChatGPT/Claude/Gemini)
- ☐ Prompt Pack opens and copy buttons work
- ☐ AI Safety Card is accessible
- ☐ Windows→Wadsworth Cheat Sheet is accessible
- ☐ Desktop "AI" folder exists (if used)

---

## E) Support readiness
- ☐ RustDesk launches
- ☐ No unattended access configured
- ☐ Support instructions available (Support doc/link)

---

## F) Final physical / packaging
- ☐ Laptop cleaned (screen/keyboard/palmrest)
- ☐ Ports dust-free
- ☐ Sticker/branding applied (if used)
- ☐ Photos taken for listing (top, keyboard, ports, screen-on, system info)
- ☐ Listing disclosure includes "Linux Mint (NOT Windows)"
- ☐ Packaged safely (padding; charger included)

Final Notes: __________________________________________________________
